<?php

/**
 * @package     SP Simple Portfolio
 *
 * @copyright   Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */
defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

require_once JPATH_COMPONENT . '/helpers/helper.php';
SpsimpleportfolioHelper::generateMeta($this->item);


$doc = Factory::getDocument();
$doc->addStylesheet(Uri::root(true) . '/components/com_spsimpleportfolio/assets/css/spsimpleportfolio.css');

$tags = SpsimpleportfolioHelper::getTags((array) $this->item->spsimpleportfolio_tag_id);
$newtags = array();
foreach ($tags as $tag) {
	$newtags[] 	 = $tag->title;
}

//video
if ($this->item->video) {
	$video = parse_url($this->item->video);

	switch ($video['host']) {
		case 'youtu.be':
			$video_id 	= trim($video['path'], '/');
			$video_src 	= '//www.youtube.com/embed/' . $video_id;
			break;

		case 'www.youtube.com':
		case 'youtube.com':
			parse_str($video['query'], $query);
			$video_id 	= $query['v'];
			$video_src 	= '//www.youtube.com/embed/' . $video_id;
			break;

		case 'vimeo.com':
		case 'www.vimeo.com':
			$video_id 	= trim($video['path'], '/');
			$video_src 	= "//player.vimeo.com/video/" . $video_id;
	}
}

?>

<div id="sp-simpleportfolio" class="sp-simpleportfolio sp-simpleportfolio-view-item">
	<div class="sp-simpleportfolio-info">
		<div class="sp-simpleportfolio-category">
			<h2>Portfolio</h2>
		</div>
		<div class="sp-simpleportfolio-title">
			<h2><?php echo $this->item->title; ?></h2>
		</div>
		<div class="sp-simpleportfolio-meta">
			<ul>
				<?php if (isset($this->item->client) && $this->item->client) { ?>
					<li>
						<div class="sp-simpleportfolio-clients">
							<span><?php echo Text::_('COM_SPSIMPLEPORTFOLIO_PROJECT_CLIENT'); ?>: </span> <?php echo $this->item->client; ?>
						</div>
					</li>
				<?php } //has project client 
				?>

				<li>
					<div class="sp-simpleportfolio-tags">
						<span><?php echo Text::_('COM_SPSIMPLEPORTFOLIO_PROJECT_TAGS') . ": "; ?></span>
						<?php echo implode(', ', $newtags); ?>
					</div>
				</li>
				<li>
					<div class="sp-simpleportfolio-created">
						<span><?php echo Text::_('COM_SPSIMPLEPORTFOLIO_PROJECT_DATE') . ": "; ?></span>
						<?php echo JHtml::_('date', $this->item->created_on, Text::_('DATE_FORMAT_LC3')); ?>
					</div>
				</li>
				<li>
					<?php if ($this->item->url) { ?>
						<div class="sp-simpleportfolio-link">
							<a class="btn btn-primary" target="_blank" href="<?php echo $this->item->url; ?>"><?php echo Text::_('COM_SPSIMPLEPORTFOLIO_VIEW_PROJECT'); ?></a>
						</div>
					<?php } ?>
				</li>
			</ul>
		</div>
	</div> <!-- //sp-simpleportfolio-info -->

	<div class="sp-simpleportfolio-image">
		<?php if ($this->item->video) { ?>
			<div class="sp-simpleportfolio-embed">
				<iframe src="<?php echo $video_src; ?>" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
			</div>
		<?php } else { ?>
			<?php if ($this->item->image) { ?>
				<img class="sp-simpleportfolio-img" src="<?php echo $this->item->image; ?>" alt="<?php echo $this->item->title; ?>">
			<?php } else { ?>
				<img class="sp-simpleportfolio-img" src="<?php echo $this->item->thumbnail; ?>" alt="<?php echo $this->item->title; ?>">
			<?php } ?>
		<?php } ?>
	</div> <!-- //sp-simpleportfolio-image -->

	<div class="sp-simpleportfolio-details clearfix">
		<div class="sp-simpleportfolio-description">
			<?php echo $this->item->description; ?>
		</div>
	</div> <!-- //sp-simpleportfolio-description -->
</div>