<?php
/**
 * @package     SP Simple Portfolio
 * @subpackage  mod_spsimpleportfolio
 *
 * @copyright   Copyright (C) 2010 - 2022 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Component\ComponentHelper;


jimport('joomla.filesystem.file');
$layout_type = $params->get('layout_type', 'default');

//Params
$cparams = ComponentHelper::getParams('com_spsimpleportfolio');
$square = strtolower($cparams->get('square', '600x600'));
$rectangle = strtolower($cparams->get('rectangle', '600x400'));
$tower = strtolower($cparams->get('tower', '600x800'));

$i = 0;
//Sizes
$sizes = array(
    $rectangle,
    $tower,
    $square,
    $rectangle,
    $tower,
    $square,
    $tower,
    $rectangle,
    $square,
    $square,
    $rectangle,
    $tower
);

?>


<div id="mod-sp-simpleportfolio" class="sp-simpleportfolio sp-simpleportfolio-view-items layout-<?php echo str_replace('_', '-', $layout_type); ?> <?php echo $moduleclass_sfx; ?>">

    <?php if ($params->get('show_filter', 1)) { ?>
        <div class="sp-simpleportfolio-filter">
            <ul>
                <li class="active" data-group="all"><a href="#"><?php echo Text::_('MOD_SPSIMPLEPORTFOLIO_SHOW_ALL'); ?></a></li>
                <?php
                $filters = SpsimpleportfolioHelper::getTagList($items);
                foreach ($filters as $filter) {
                    ?>
                    <li data-group="<?php echo $filter->alias; ?>"><a href="#"><?php echo $filter->title; ?></a></li>
                    <?php
                }
                ?>
            </ul>
        </div>
    <?php } ?>

    <?php
    //Videos
    foreach ($items as $item) {

        if ($item->video) {
            $video = parse_url($item->video);

            switch ($video['host']) {
                case 'youtu.be':
                    $video_id = trim($video['path'], '/');
                    $video_src = '//www.youtube.com/embed/' . $video_id;
                    break;

                case 'www.youtube.com':
                case 'youtube.com':
                    parse_str($video['query'], $query);
                    $video_id = $query['v'];
                    $video_src = '//www.youtube.com/embed/' . $video_id;
                    break;

                case 'vimeo.com':
                case 'www.vimeo.com':
                    $video_id = trim($video['path'], '/');
                    $video_src = "//player.vimeo.com/video/" . $video_id;
            }

            echo '<iframe class="sp-simpleportfolio-lightbox" src="' . $video_src . '" width="500" height="281" id="sp-simpleportfolio-video' . $item->spsimpleportfolio_item_id . '" style="border:none;" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
        }
    }
    ?>

    <div class="sp-simpleportfolio-items sp-simpleportfolio-columns-<?php echo $params->get('columns', 3); ?>">
        <?php foreach ($items as $item) { ?>

            <?php
                $tags = SpsimpleportfolioHelper::getTags($item->spsimpleportfolio_tag_id);
                $newtags = array();
                $filter = '';
                $groups = array();
                foreach ($tags as $tag) {
                    $newtags[] = $tag->title;
                    $filter .= ' ' . $tag->alias;
                    $groups[] .= '"' . $tag->alias . '"';
                }

                $groups = implode(',', $groups);

            ?>

            <div class="sp-simpleportfolio-item" data-groups='[<?php echo $groups; ?>]'>
                <?php $item->url = Route::_('index.php?option=com_spsimpleportfolio&view=item&id=' . $item->spsimpleportfolio_item_id . ':' . $item->alias . SpsimpleportfolioHelper::getItemid()); ?>

                <div class="sp-simpleportfolio-overlay-wrapper clearfix">

                    <?php if ($item->video) { ?>
                        <span class="sp-simpleportfolio-icon-video"></span>
                    <?php } ?>

                    <?php if ($params->get('thumbnail_type', 'masonry') == 'masonry') { ?>
                        <img class="sp-simpleportfolio-img" src="<?php echo Uri::base(true) . '/images/spsimpleportfolio/' . $item->alias . '/' . File::stripExt(basename($item->image)) . '_' . $sizes[$i] . '.' . File::getExt($item->image); ?>" alt="<?php echo $item->title; ?>">
                    <?php } else if ($params->get('thumbnail_type', 'masonry') == 'rectangular') { ?>
                        <img class="sp-simpleportfolio-img" src="<?php echo Uri::base(true) . '/images/spsimpleportfolio/' . $item->alias . '/' . File::stripExt(basename($item->image)) . '_' . $rectangle . '.' . File::getExt($item->image); ?>" alt="<?php echo $item->title; ?>">
                    <?php } else { ?>
                        <img class="sp-simpleportfolio-img" src="<?php echo Uri::base(true) . '/images/spsimpleportfolio/' . $item->alias . '/' . File::stripExt(basename($item->image)) . '_' . $square . '.' . File::getExt($item->image); ?>" alt="<?php echo $item->title; ?>">
                    <?php } ?>

                    <div class="sp-simpleportfolio-overlay">
                        <div class="sp-vertical-middle">
                            <div>
                                <?php if ($layout_type != 'default') { ?>
                                    <div class="sp-simpleportfolio-tags">
                                        <?php echo implode(', ', $newtags); ?>
                                    </div>
                                    <h3 class="sp-simpleportfolio-title">
                                        <a href="<?php echo $item->url; ?>">
                                            <?php echo $item->title; ?>
                                        </a>
                                    </h3>
                                <?php } ?>
                                <div class="sp-simpleportfolio-btns">
                                    <?php if ($item->video) { ?>
                                        <a class="btn-zoom" href="#" data-featherlight="#sp-simpleportfolio-video<?php echo $item->spsimpleportfolio_item_id; ?>"><?php echo Text::_('COM_SPSIMPLEPORTFOLIO_WATCH'); ?></a>
                                    <?php } else { ?>
                                        <a class="btn-zoom" href="<?php echo Uri::base(true) . '/images/spsimpleportfolio/' . $item->alias . '/' . File::stripExt(basename($item->image)) . '_' . $rectangle . '.' . File::getExt($item->image); ?>" data-featherlight="image"><?php echo Text::_('MOD_SPSIMPLEPORTFOLIO_ZOOM'); ?></a>
                                    <?php } ?>
                                    <a class="btn-view" href="<?php echo $item->url; ?>"><span class="icon icon-right"></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($layout_type == 'default') { ?>
                    <div class="sp-simpleportfolio-info">
                        <div class="sp-simpleportfolio-tags">
                            <?php echo implode(', ', $newtags); ?>
                        </div>
                        <h3 class="sp-simpleportfolio-title">
                            <a href="<?php echo $item->url; ?>">
                                <?php echo $item->title; ?>
                            </a>
                        </h3>
                    </div>
                <?php } ?>

            </div>

            <?php
            $i++;
            if ($i == 11) {
                $i = 0;
            }
            ?>

        <?php } ?>
    </div>

</div>
