<?php

/**
 * @package Ares-murphy
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2017 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted aceess');

class SppagebuilderAddonImage_slideshow extends SppagebuilderAddons
{

    public function render()
    {
        $autoplay = (isset($this->addon->settings->autoplay) && $this->addon->settings->autoplay) ? $this->addon->settings->autoplay : '';
        $controllers = (isset($this->addon->settings->controllers) && $this->addon->settings->controllers) ? $this->addon->settings->controllers : '';
        $arrows = (isset($this->addon->settings->arrows) && $this->addon->settings->arrows) ? $this->addon->settings->arrows : '';
        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';

        //Check Auto Play
        $slide_autoplay = ($autoplay) ? 'data-sppb-slide-ride="true"' : '';
        $slide_controllers = ($controllers) ? 'data-sppb-slide-controllers="true"' : '';


        //output
        $output = '<div class="sppb-addon-image-slider owl-theme' . $class . '">';
        $output .= '<div id="image-slider" class="image-slider owl-carousel" ' . $slide_controllers . ' ' . $slide_autoplay . ' >';

        foreach ($this->addon->settings->sp_slideshow_full_item as $key => $slide_item) {
            $attribs = (isset($slide_item->url) && $slide_item->url) ? ' href="' . $slide_item->url . '"' : '';
            $attribs .= (isset($slide_item->target) && $slide_item->target) ? ' target="' . $slide_item->target . '"' : '';

            $output .= '<div class="sppb-slideshow-fullwidth-item item">';
            $output .= '<div class="img-wrapper">';
            $src = "";
            if (isset($slide_item->bg)) {
                if (is_object($slide_item->bg)) {
                    $src = $slide_item->bg->src;
                } elseif (is_string($slide_item->bg)) {
                    $src = $slide_item->bg;
                }
                if(strpos($src, "http://") === 0 || strpos($src, "https://") === 0){
                    $src = $src;
                } else {
                    $src = JURI::base() . $src;
                }
            }
            $output .= '<img class="img-responsive" src="' . $src . '" alt="">';
            $output .= '</div>';
            $output .= '<div class="overlay"></div>';
            $output .= '<div class="sppb-slideshow-fullwidth-item-text">';

            if (($slide_item->title) || ($slide_item->sub_title) || ($slide_item->content)) {

                if ($slide_item->title) {

                    if (isset($slide_item->url) && $slide_item->url) {
                        $output .= '<a ' . $attribs . '>';
                    }
                    $output .= '<h1 class="sppb-fullwidth-title"> ' . $slide_item->title . ' </h1>';
                    if (isset($slide_item->url) && $slide_item->url) {
                        $output .= '</a>';
                    }
                }
                if ($slide_item->sub_title) {
                    $output .= '<h2 class="sppb-fullwidth-sub-title">' . $slide_item->sub_title . '</h2>';
                }

                if ($slide_item->content) {
                    $output .= '<p class="details">' . $slide_item->content . '</p>';
                }
            }

            $output .= '</div>'; // END:: /.sppb-slideshow-fullwidth-item-text
            $output .= '</div>'; // END:: /.sppb-slideshow-fullwidth-item
        }

        $output .= '</div>'; //END:: /.sppb-slider-items
        // has next/previous arrows
        if ($arrows) {
            $output .= '<div class="customNavigation">';
            $output .= '<h4 class="sppbSlidePrev">' . JText::_('COM_SPPAGEBUILDER_ADDON_SF_PREV') . '</h4>';
            $output .= '<h4 class="sppbSlideNext">' . JText::_('COM_SPPAGEBUILDER_ADDON_SF_NEXT') . '</h4>';
            $output .= '</div>'; // END:: /.customNavigation
        }

        $output .= '</div>'; // /.sppb-slider-wrapper

        return $output;
    }

    public function scripts()
    {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/js/';
        return array($base_path . 'owl.carousel.min.js', $base_path . 'addon.slider.js');
    }

    public function js()
    {
        $addon_id = '#sppb-addon-' . $this->addon->id;
        return '
            jQuery(document).ready(function($){"use strict";

            var $slideFullwidth = $("' . $addon_id . ' #image-slider");

            var $autoplay   = $slideFullwidth.attr("data-sppb-slide-ride");
            if ($autoplay == "true") { var $autoplay = true; } else { var $autoplay = false};

            var $controllers   = $slideFullwidth.attr("data-sppb-slide-controllers");
            if ($controllers == "true") { var $controllers = true; } else { var $controllers = false};

            $slideFullwidth.owlCarousel({
                margin: 30,
                loop: true,
                video:true,
                autoplay: $autoplay,
                animateIn: "fadeIn",
                animateOut: "fadeOut",
                autoplayHoverPause: true,
                autoplaySpeed: 1500,
                responsive: {
                    0: {
                        items: 1
                    },
                    600: {
                        items: 2
                    },
                    1000: {
                        items: 3
                    }
                },
                dots: $controllers,
            });

            $(".sppbSlidePrev").click(function(){
                $slideFullwidth.trigger("prev.owl.carousel", [400]);
            });

            $(".sppbSlideNext").click(function(){
                $slideFullwidth.trigger("next.owl.carousel",[400]);
            });
        });
            ';
    }

    public function stylesheets()
    {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/css/';
        return array($base_path . 'owl.carousel.css', $base_path . 'owl.theme.css', $base_path . 'owl.transitions.css', $base_path . 'slide-animate.css');
    }

    public function css()
    {
        $addon_id = '#sppb-addon-' . $this->addon->id;
        $addont_styles = '';
        $addont_styles .= (isset($this->addon->settings->background) && $this->addon->settings->background) ? 'background: ' . $this->addon->settings->background . '; ' : '';
        $addont_styles .= (isset($this->addon->settings->color) && $this->addon->settings->color) ? 'color: ' . $this->addon->settings->color . '; ' : '';

        $css = '';
        if ($addont_styles) {
            $css .= $addon_id . ' .sppb-slider-fullwidth-wrapper .sppb-slider-item-wrapper {';
            $css .= $addont_styles;
            $css .= '}';
        }

        return $css;
    }

    public static function getTemplate()
    {
        $output = '
            <#
                var autoplay = (typeof data.autoplay !== "undefined") ? data.autoplay : 0;
                var controllers = (typeof data.controllers !== "undefined") ? data.controllers : 0;
                var arrows = (typeof data.arrows !=="undefined") ? data.arrows : 0;
                var contentClass = (!_.isEmpty(data.class)) ? data.class : "";

                var slide_autoplay = (autoplay > 0) ? \'data-sppb-slide-ride="true"\' : \'data-sppb-slide-ride="false"\';
                var slide_controllers = (controllers > 0) ? \'data-sppb-slide-controllers="true"\' : \'data-sppb-slide-controllers="false"\';
            #>

                <div class="sppb-addon-image-slider owl-theme {{contentClass}}">
                <div id="image-slider" class="image-slider owl-carousel" {{{slide_controllers}}} {{{slide_autoplay}}} >

            <# _.each (data.sp_slideshow_full_item, function(slide_item, slide_key) {
                    var attribs     = (!_.isEmpty(slide_item.url)) ? \' href="\' + slide_item.url + \'"\': "";
                    attribs     += (!_.isEmpty(slide_item.target)) ? \' target="\' + slide_item.target + \'"\': "";

                    let service_image = "";
                    if(typeof slide_item.bg !== "undefined") {
                        if(typeof slide_item.bg === "object"){
                            if(slide_item.bg.src.indexOf("http://") === 0 || slide_item.bg.src.indexOf("https://") === 0){
                                service_image = `${slide_item.bg.src}`;
                            } else {
                                service_image = `${slide_item.bg.src}`;
                            }
                        } else {
                            if(slide_item.bg.indexOf("http://") === 0 || slide_item.bg.indexOf("https://") === 0){
                                service_image = `${slide_item.bg}`;
                            } else {
                                service_image = `${slide_item.bg}`;
                            }
                        }
                    }
            #>

                    <div class="sppb-slideshow-fullwidth-item item">
                        <div class="img-wrapper">

                        <img class="img-responsive" src="{{service_image }}" alt="">
                    </div>
                    <div class="overlay"></div>
                    <div class="sppb-slideshow-fullwidth-item-text">

                    <# if ((slide_item.title) || (slide_item.sub_title) || (slide_item.content)) {

                        if (slide_item.title) {

                            if(!_.isEmpty(slide_item.url) && slide_item.url) {
                    #>
                                <a {{{attribs}}}>
                    <# } #>
                            <h1 class="sppb-fullwidth-title"> {{slide_item.title}}</h1>
                            <# if(!_.isEmpty(slide_item.url) && slide_item.url) { #>
                                </a>
                            <# } #>
                        <# } #>
                        <# if (slide_item.sub_title) { #>
                            <h2 class="sppb-fullwidth-sub-title">{{{slide_item.sub_title}}}</h2>
                        <# } #>

                        <# if (slide_item.content) { #>
                            <p class="details">{{slide_item.content}}</p>
                        <# } #>
                    <# } #>

                    </div>
                    </div>
                <# }) #>

                </div>
                <# if (arrows > 0) { #>
                    <div class="customNavigation">
                    <h4 class="sppbSlidePrev">' . JText::_('COM_SPPAGEBUILDER_ADDON_SF_PREV') . '</h4>
                    <h4 class="sppbSlideNext">' . JText::_('COM_SPPAGEBUILDER_ADDON_SF_NEXT') . '</h4>
                    </div>
                <# } #>

                </div>
                ';
        return $output;
    }
}
