<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted aceess');

class SppagebuilderAddonSocial_media extends SppagebuilderAddons
{

    public function render()
    {
        // Addon Options
        $class = isset($this->addon->settings->class) ? htmlspecialchars($this->addon->settings->class) : '';

        // Title font weight and other styles
        $title_fontweight = (isset($this->addon->settings->title_fontweight) && $this->addon->settings->title_fontweight) ? 'font-weight: ' . htmlspecialchars($this->addon->settings->title_fontweight) . ';' : '';
        $title_color = (isset($this->addon->settings->title_text_color) && $this->addon->settings->title_text_color) ? 'color: ' . htmlspecialchars($this->addon->settings->title_text_color) . ';' : '';

        // Combine all title styles
        $title_style = $title_fontweight . $title_color;

        $title = isset($this->addon->settings->title) ? htmlspecialchars($this->addon->settings->title) : '';

        $title_position = isset($this->addon->settings->title_position) ? $this->addon->settings->title_position : '';

        $heading_selector = isset($this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';

        $social_items = isset($this->addon->settings->sp_social_media_items) ? $this->addon->settings->sp_social_media_items : [];

        $output = '';
        $output .= '<div class="sppb-addon sppb-addon-social-media ' . $class . '">';
        $output .= '<div class="social-media-text-wrap">';

        // Render title at the top
        if ($title_position === 'Top') {
            $output .= $title ? '<' . htmlspecialchars($heading_selector) . ' class="sppb-addon-title">' . $title . '</' . htmlspecialchars($heading_selector) . '>' : '';
        }

        $output .= '</div>';

        foreach ($social_items as $social_item) {
            $social = '';

            if (isset($social_item->class) && !empty($social_item->class)) {
                $social = htmlspecialchars($social_item->class);
            }

            if (isset($social_item->url) && !empty($social_item->url)) {
                $output .= '<a href="' . htmlspecialchars($social_item->url) . '" class="' . $social . '">';
            }

            $icon_class = '';

            if (isset($social_item->icon_resource) && $social_item->icon_resource === 'aresicon' && isset($social_item->aresicon) && !empty($social_item->aresicon)) {
                $icon_class = htmlspecialchars($social_item->aresicon);
            } elseif (isset($social_item->faicon) && !empty($social_item->faicon)) {
                $icon_class = htmlspecialchars($social_item->faicon);
            } else {
                $icon_class = 'fas fa-question-circle';
            }

            $output .= '<i class="' . $icon_class . '"></i>';

            if (isset($social_item->url) && !empty($social_item->url)) {
                $output .= '</a>';
            }
        }

        if ($title_position === 'Bottom') {
            $output .= $title ? '<' . htmlspecialchars($heading_selector) . ' class="sppb-addon-title">' . $title . '</' . htmlspecialchars($heading_selector) . '>' : '';
        }

        $output .= '</div>';

        return $output;
    }





    public static function getTemplate()
    {
        $output = '
            <#
                let contentClass = (!_.isEmpty(data.class) && data.class) ? data.class : "";
                let title = (!_.isEmpty(data.title) && data.title) ? data.title : "";
                let title_fontsize = (!_.isEmpty(data.title_fontsize)) ? data.title_fontsize + "px" : "";
                let title_lineheight = (!_.isEmpty(data.title_lineheight)) ? data.title_lineheight + "px" : "";
                let title_letterspace = (!_.isEmpty(data.title_letterspace)) ? data.title_letterspace : "";
                let title_margin_top = (!_.isEmpty(data.title_margin_top)) ? data.title_margin_top + "px" : "";
                let title_margin_bottom = (!_.isEmpty(data.title_margin_bottom)) ? data.title_margin_bottom + "px" : "";
                let title_fontweight = (!_.isEmpty(data.title_fontweight)) ? data.title_fontweight : "";
                let title_text_color = (!_.isEmpty(data.title_text_color)) ? data.title_text_color : "#000000";
                
                let title_position = (!_.isEmpty(data.title_position) && data.title_position) ? data.title_position : "";
                let heading_selector = (!_.isEmpty(data.heading_selector) && data.heading_selector) ? data.heading_selector : "h3";
            #>

                <div class="sppb-addon sppb-addon-social-media {{contentClass}}">
                <div class="social-media-text-wrap">
                <# if (title_position == "Top" && heading_selector !=="") { #>
                    <{{heading_selector}} class="sppb-addon-title"   style="font-size: {{title_fontsize}}; line-height: {{title_lineheight}}; letter-spacing: {{title_letterspace}}; margin-top: {{title_margin_top}}; margin-bottom: {{title_margin_bottom}}; font-weight: {{title_fontweight}}; color: {{title_text_color}};">{{{title}}}</{{heading_selector}}>
                <# } #>
                </div>

                <# _.each(data.sp_social_media_items, function(social_item) {
                    if (social_item.url) {
                #>
                        <a href="{{social_item.url}}" class="{{social_item.class}}">
                    <# }
                    if (social_item.icon_resource == "aresicon" && social_item.aresicon !=="") {
                    #>
                        <i class=" {{social_item.aresicon}}"></i>
                    <# } else { #>
                        <i class="fa {{social_item.faicon}}"></i>
                    <# }
                    if (social_item.url) {
                    #>
                        </a>
                    <# }
                })

                if (title_position == "Bottom" && heading_selector !=="") {
                #>
                    <{{heading_selector}} class="sppb-addon-title"   style="font-size: {{title_fontsize}}; line-height: {{title_lineheight}}; letter-spacing: {{title_letterspace}}; margin-top: {{title_margin_top}}; margin-bottom: {{title_margin_bottom}}; font-weight: {{title_fontweight}}; color: {{title_text_color}};">{{{title}}}</{{heading_selector}}>
                <# } #>

                </div>
                ';
        return $output;
    }
}
