<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted aceess');

class SppagebuilderAddonTestimonialpro extends SppagebuilderAddons
{

    public function render()
    {

        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
        $style = (isset($this->addon->settings->style) && $this->addon->settings->style) ? $this->addon->settings->style : '';

        //Options
        $autoplay = (isset($this->addon->settings->autoplay) && $this->addon->settings->autoplay) ? ' data-sppb-ride="sppb-carousel"' : '';
        $arrows = (isset($this->addon->settings->arrows) && $this->addon->settings->arrows) ? $this->addon->settings->arrows : '';
        $controls = (isset($this->addon->settings->controls) && $this->addon->settings->controls) ? $this->addon->settings->controls : 0;
        $designation = (isset($this->addon->settings->designation) && $this->addon->settings->designation) ? $this->addon->settings->designation : 0;

        //Output
        $output = '<div id="sppb-testimonial-pro-' . $this->addon->id . '" class="sppb-carousel sppb-testimonial-pro sppb-slide sppb-text-center' . $class . '"' . $autoplay . '>';

        if ($controls) {
            $output .= '<ol class="sppb-carousel-indicators">';
            foreach ($this->addon->settings->sp_testimonialpro_item as $key1 => $value) {
                $output .= '<li data-sppb-target="#sppb-carousel-' . $this->addon->id . '" ' . (($key1 == 0) ? ' class="active"' : '') . '  data-sppb-slide-to="' . $key1 . '"></li>' . "\n";
            }
            $output .= '</ol>';
        }

        $output .= '<div class="sppb-carousel-inner">';

        foreach ($this->addon->settings->sp_testimonialpro_item as $key => $value) {
            $output .= '<div class="sppb-item ' . (($key == 0) ? ' active' : '') . '">';
            $title = '<h5 class="pro-client-name">' . $value->title . '</h5>';
            $designation = '<h5 class="pro-client-designation">' . $value->designation . '</h5>';

            if (isset($value->url))
                $title .= ' - <span class="pro-client-url">' . $value->url . '</span>';
            $output .= '<div class="sppb-testimonial-message">' . $value->message . '</div>';
            $output .= '<div class="sppb-testimonial-info">';
            $avatarUrl = "";
            if (gettype($value->avatar) == "object") {
                $avatarUrl = $value->avatar->src;
            } else {
                $avatarUrl = $value->avatar;
            }
            if ($value->avatar)
                $output .= '<img class="sppb-img-responsive sppb-avatar ' . $value->avatar_style . '" src="' . $avatarUrl . '" alt="">';
            if ($title)
                $output .= '<div class="sppb-testimonial-client">' . $title . '</div>';
            if ($designation)
                $output .= $designation;

            $output .= '</div>'; //.sppb-testimonial-info
            $output .= '</div>'; //.sppb-item
        }
        $output .= '</div>'; //.sppb-carousel-inner

        if ($arrows) {
            $output .= '<a href="#sppb-testimonial-pro-' . $this->addon->id . '" class="left sppb-carousel-control" data-slide="prev"><i class="fa fa-angle-left"></i></a>';
            $output .= '<a href="#sppb-testimonial-pro-' . $this->addon->id . '" class="right sppb-carousel-control" data-slide="next"><i class="fa fa-angle-right"></i></a>';
        }

        $output .= '</div>';

        return $output;
    }

    public static function getTemplate()
    {
        $output = '
                <#
                    var contentClass = (!_.isEmpty(data.class) && data.class) ? data.class : "";
                    var style = (!_.isEmpty(data.style) && data.style) ? data.style : "";

                    var autoplay = (typeof data.autoplay !=="undefined") ? \' data-sppb-ride="sppb-carousel"\' : "";
                    var arrows = (typeof data.arrows !=="undefined") ? data.arrows : 0;
                    var controls = (typeof data.controls !=="undefined") ? data.controls : 0;
                    var designation = (!_.isEmpty(data.designation) && data.designation) ? data.designation : "";
                #>
                    <div id="sppb-testimonial-pro-{{data.id}}" class="sppb-carousel sppb-testimonial-pro sppb-slide sppb-text-center {{contentClass}}" {{{autoplay}}}>

                    <# if(controls > 0) { #>
                            <ol class="sppb-carousel-indicators">
                            <# _.each (data.sp_testimonialpro_item,function(value, index) {
                            let slideActClass = ""
                            if (index == 0) {
                                    slideActClass = " active"
                            } else {
                                    slideActClass = ""
                            }
                            #>
                                    <li data-sppb-target="#sppb-carousel-{{data.id}}" class="{{slideActClass}}" data-sppb-slide-to="{{key}}"></li>
                            <# }) #>
                            </ol>
                    <# } #>

                    <div class="sppb-carousel-inner">

                        <# _.each (data.sp_testimonialpro_item, function(value, index) {
                        let slideActClass = ""
                        if (index == 0) {
                                slideActClass = " active"
                        } else {
                                slideActClass = ""
                        }
                        #>
                            <div class="sppb-item {{slideActClass}}">
                            <#
                            var title = \'<h5 class="pro-client-name">\'+ value.title + \'</h5>\';
                            var designation = \'<h5 class="pro-client-designation">\'+ value.designation + \'</h5>\';

                            if(value.url){ title += \' - <span class="pro-client-url">\'+ value.url + \'</span>\';}
                            #>
                           <div class="sppb-testimonial-message">{{{value.message}}}</div>
                            <div class="sppb-testimonial-info">
                            <#
                            if(value.avatar){
                            #>
                            <img class="sppb-img-responsive sppb-avatar {{value.avatar_style}}" src="{{value.avatar.src ?value.avatar.src: value.avatar }}" alt="">
                            <# }
                            if(title){
                            #>
                            <div class="sppb-testimonial-client">{{{title}}}</div>
                            <# }
                            if(designation){
                            #>
                            {{{designation}}}
                            <# } #>

                            </div>
                            </div>
                        <# }) #>

                    </div>

                    <# if(arrows>0) { #>
                        <a href="#sppb-testimonial-pro-{{data.id}}" class="left sppb-carousel-control" data-slide="prev"><i class="fa fa-angle-left"></i></a>
                        <a href="#sppb-testimonial-pro-{{data.id}}" class="right sppb-carousel-control" data-slide="next"><i class="fa fa-angle-right"></i></a>
                    <# } #>

                    </div>
                    ';
        return $output;
    }
}
